//---------------------------------------------------------------------------

#pragma hdrstop
#include <windows.h>
#include <wincrypt.h>
#include <stdio.h>
#include "cptumar.h"
//---------------------------------------------------------------------------

#pragma argsused
#define MY_ENCODING_TYPE  (PKCS_7_ASN_ENCODING | X509_ASN_ENCODING)
void Url2Prof(char *url, ContInfoEx *ContInfo);
void Prof2Url(ContInfoEx *ContInfo);

int main(int argc, char* argv[])
{
char* profile = "profile://2sign";
unsigned char* cert=NULL;
long certSize=0;
FILE *f=NULL;
int f_len=0;
PCCERT_CONTEXT pCertContext=NULL;
HCRYPTPROV hProv=0;
ContInfoEx ContInfo;
char sn[64];

f = fopen("cert.cer","rb");
if (f==NULL) return 1;
fseek(f,SEEK_SET,SEEK_END);
f_len = ftell(f);
cert = (BYTE*)malloc(f_len);
if (cert==NULL) { fclose(f); return 1;}
memset(cert,0,f_len);
certSize = f_len;
fseek(f,0,SEEK_SET);
f_len = ftell(f);
fread(cert,certSize,1,f);
fclose(f);
pCertContext = CertCreateCertificateContext(MY_ENCODING_TYPE,cert,certSize);
if (!pCertContext) return 1;
memset(sn,0,sizeof(sn));
//        ,  
for(int i =pCertContext->pCertInfo->SerialNumber.cbData-1 ,j=0;i>=0;i--,j++)
{
        sn[j] = pCertContext->pCertInfo->SerialNumber.pbData[i];
}

Url2Prof(profile,&ContInfo);
memset(ContInfo.sn,0,sizeof(ContInfo.sn));
//  URL
memcpy(ContInfo.sn,sn, strlen(sn));
ContInfo.sn_size = strlen(sn);
Prof2Url(&ContInfo);
CryptAcquireContext(&hProv,ContInfo.Url,NULL,25,0);  
if (hProv==0)  {CertFreeCertificateContext(pCertContext); return 2; }//  ,  URL  
CertFreeCertificateContext(pCertContext);
CryptReleaseContext(hProv,0);
return 0;
}

void Url2Prof(char *url, ContInfoEx *ContInfo)
{
DWORD cbData;
HCRYPTPROV hProv=0;
CryptAcquireContext(&hProv, NULL, NULL,25,CRYPT_VERIFYCONTEXT);
memset(ContInfo,0,sizeof(ContInfoEx));
strcpy(ContInfo->Url,url);
cbData = sizeof(ContInfoEx);
CryptGetProvParam(hProv, PP_URL_TO_PROF, (BYTE *)ContInfo, &cbData, 0);
if( hProv!=0 ) CryptReleaseContext(hProv,0);

}

void Prof2Url(ContInfoEx *ContInfo)
{
DWORD cbData;
HCRYPTPROV hProv=0;
CryptAcquireContext(&hProv, NULL, NULL,25,CRYPT_VERIFYCONTEXT);
cbData = sizeof(ContInfoEx);
CryptGetProvParam(hProv, PP_PROF_TO_URL, (BYTE *)ContInfo, &cbData, 0);
if( hProv!=0 ) CryptReleaseContext(hProv,0);

}

//---------------------------------------------------------------------------
 